// Here is all stuff that is not used in main file
#ifndef (TheCity)
  light_source { <10,15,-15> color rgb 1 }
  light_source { <-10,15,15> color rgb 1 }
  camera { location <4,2,4> look_at <2,1,1> angle 60 }
#end

/*
- Kyltit jokaisen talon eteen, nim kyltit mainostavat kaupan tarjoamia tuotteita.
- Ovet ja ikkunaluukut, auki useimmissa kaupoissa
- Teksturoinnin parantamista ja korvaamista osin objekteilla
*/

#local katto =
texture {
  pigment { color rgb <.32,.17,.12> }
  normal  { brick .1 turbulence .75 rotate y*90 scale .03 rotate x*90 }
}
texture {
  pigment {
    bozo
    color_map {
      [0 color rgbt <0,0,0,.6>]
      [.5 color rgbt <0,0,0,1>]
      [1 color rgbt <0,0,0,.6>]
    }
  }
}

#local window = texture { pigment { color rgb <.32,.17,.12>*1.3 } normal { wood .125 turbulence .125 scale .01 } }

#local wall = 
texture { 
  pigment { 
      granite 
      turbulence .5
      colour_map {
        [0  color rgb .25]
        [.25 color rgb .5]
        [.5 color rgb .6]
        [.75 color rgb .5]
        [1  color rgb .25]
      }
      scale 5
    scale .03 
  } 
  normal {
    brick .2 
    scale .03 
    turbulence .5
  }
  translate .05
}
texture {
  pigment {
    bozo
    color_map {
      [0 color rgbt <0,0,0,.8>]
      [.5 color rgbt <0,0,0,1>]
      [1 color rgbt <0,0,0,.8>]
    }
  }
}


#local stones =
texture { 
  pigment { 
    brick
    pigment { color rgb 0.3 }
    pigment{
      granite 
      colour_map {
        [0  color rgb .25]
        [.25 color rgb .5]
        [.5 color rgb .6]
        [.75 color rgb .5]
        [1  color rgb .25]
      }
      scale 10
    }
    scale .0125 } 
}
texture {
  pigment {
    bozo
    color_map {
      [0 color rgbt <0,0,0,0>]
      [.5 color rgbt <0,0,0,1>]
      [1 color rgbt <0,0,0,0>]
    }
  }
}

#declare house = 
union{
  sphere { <1.5,.8,.75> .2 pigment { color rgb <.8,.8,.5>} finish { ambient .4 } }
  difference {
    box { <0,0,0> <3,1,1.5> texture { wall } }              // House walls
    box { <0.15,0.0125,0.15> <2.85,1.2,1.35> texture {window finish {ambient .3}} } // Houses are hollow after all
    box { <.75,.25,-.25> <1,.4,1.7> texture {window} }      // Window
    box { <.75,.7,-.25> <1,.9,1.7> texture {window} }       // Window
    box { <1.375,.7,-.25> <1.625,.9,1.7> texture {window} } // Window
    box { <2.25,.25,-.25> <2,.4,1.7> texture {window} }     // Window
    box { <2.25,.7,-.25> <2,.9,1.7> texture {window} }      // Window
    box { <1.4,0.013,-.25> <1.7,.4,1.7> texture {window} }  // Door
  }
  difference {
    box { <1,0,1> <1.2,1.3,1.2> texture {stones}}                     // Smoke pipe, what is it in english ...
    box { <1.05,.5,1.05> <1.15,1.4,1.15> texture {stones} texture {pigment {color rgbt <0,0,0,.5>}}}            // Hollow? Well someone might have a closer look...
  }
  difference {  // Kattokolmio
    box { <0,0,0> <3,-.3,.78745> rotate x*-15 translate y*1 } 
    box { -1 , <4,1,2> }
    texture { wall } 
  }
  difference {  // Kattokolmio
    box { <0,0,0> <3,-.3,-.78745> rotate x*15 translate y*1+z*1.5 }
    box { -1 , <4,1,2> }
    texture { wall } 
  }
  // Roof
  box { <-.05,0,-.05> <3.05,.05,.78745> texture { katto } rotate x*-15 translate y*1 }
  box { <-.05,0,.05> <3.05,.05,-.78745> texture { katto } rotate x*15 translate y*1+z*1.5 }
}

#local katto_b =
texture {
  pigment { color rgb <.6,.4,.4> }
  normal  { brick .1 turbulence .75 rotate y*90 scale .03 rotate x*90 }
}
texture {
  pigment {
    bozo
    color_map {
      [.2 color rgbt <0,0,0,.75>]
      [.5 color rgbt <0,0,0,1>]
      [.8 color rgbt <0,0,0,.75>]
    }
  }
}

#local wall_b = 
texture { 
  pigment {
    bozo
    turbulence 1
    color_map {
      [0 color rgb <.95,.9,.8>*.9]
      [.5 color rgb <.95,.9,.8> ]
      [1 color rgb <.95,.9,.8>*.9]
    }
  }
  normal {
    bumps .3 scale .02
  }
}

#declare house_b = 
union{
  sphere { <1.5,.8,.75> .2 pigment { color rgb <.8,.8,.5>} finish { ambient .4 } }
  difference {
    box { <0,0,0> <3,1,1.5> texture { wall_b }}             // House walls
    box { <0.15,0.0125,0.15> <2.85,1.2,1.35> }              // Houses are hollow after all
    box { <.75,.125,-.25> <1,.4,1.7> texture {window} }      // Window
    box { <.75,.7,-.25> <1,.9,1.7> texture {window} }       // Window
    box { <1.425,.7,-.25> <1.675,.9,1.7> texture {window} } // Window
    box { <2.25,.125,-.25> <2.5,.4,1.7> texture {window} }     // Window
    box { <2.25,.7,-.25> <2.5,.9,1.7> texture {window} }      // Window
    box { <1.4,.01,-.25> <1.7,.4,1.7> texture {window} }    // Door
  }
  difference {
    box { <1,0,1> <1.2,1.3,1.2> texture {stones}}                     // Smoke pipe, what is it in english ...
    box { <1.05,.5,1.05> <1.15,1.4,1.15> texture {stones} texture {pigment {color rgbt <0,0,0,.5>}}}            // Hollow? Well someone might have a closer look...
  }
  
  box { <-.01,.6,-.01> <3.01,.5,1.51> texture { window } }

  box { <-.01,0,-.01> <.125,1,.125> texture { window } }
  box { <1.2,0,-.01> <1.1,1,.125> texture { window } }
  box { <1.9,0,-.01> <2.0,1,.125> texture { window } }
  box { <3.01,0,-.01> <2.875,1,.125> texture { window } }

  box { <-.01,0,.775> <.125,1.2,.725> texture { window } }
  box { <3.01,0,.775> <2.875,1.2,.725> texture { window } }

  box { <-.01,0,1.51> <.125,1,1.375> texture { window } }
  box { <1.2,0,1.51> <1.1,1,1.375> texture { window } }
  box { <1.9,0,1.51> <2.0,1,1.375> texture { window } }
  box { <3.01,0,1.51> <2.875,1,1.375> texture { window } }
  
  box { <0,0,.025> <.3,.4,.035> rotate y*10 translate x*1.4 texture {window} }    // Door
  box { <1.4,0,1.475> <1.7,.4,1.42> texture {window} }    // Door

  #local kyltti = #include "kyltti.pov"
  object { kyltti scale .2 rotate y*90 translate <1.4,.45,-.2> texture { window } }

  difference {  // Kattokolmio
    box { <0,0,0> <3,-.3,-.78745> rotate x*15 translate y*1+z*1.5 }
    box { -1 , <4,1,2> }
    texture { wall_b }
  }
  difference {  // Kattokolmio
    box { <0,0,0> <3,-.3,.78745> rotate x*-15 translate y*1 }
    box { -1 , <4,1,2> }
    texture { wall_b }
  }
  
  // Roof
  box { <-.05,0,-.05> <3.05,.05,.78745> texture { katto_b translate x*1.5 } rotate x*-15 translate y*1 }
  box { <-.05,0,.05> <3.05,.05,-.78745> texture { katto_b translate x*1.5 } rotate x*15 translate y*1+z*1.5 }
  pigment { color rgb <.32,.17,.12> }  
}

#local wall_c = 
texture { 
  pigment {
    brick 
    pigment {color rgb .6 }
    pigment {
      granite 
      colour_map {
        [0  color rgb .5]
        [.25 color rgb .75]
        [.5 color rgb .9]
        [.75 color rgb .75]
        [1  color rgb .5]
      }
      scale .2
      turbulence .5
    }
    brick_size <.2,.075,.1125>
    mortar .0125
    turbulence .125
  }
  normal {
    brick .05
    brick_size <.2,.075,.1125>
    mortar .0125
    turbulence .125
  }
}

#local wall_d = 
texture { 
  pigment {
    bozo
    turbulence 1
    color_map {
      [0 color rgb <.85,.825,.8>*.9]
      [.5 color rgb <.85,.825,.8> ]
      [1 color rgb <.85,.825,.8>*.9]
    }
  }
  normal {
    bumps .3 scale .02
  }
}

#declare house_c = 
union{
  sphere { <1.5,.8,.75> .2 pigment { color rgb <.8,.8,.5>} finish { ambient .4 } }
  difference {
    box { <0,0,0> <3,1,1.5> texture { wall_d } }              // House walls
    box { <0.15,0.0125,0.15> <2.85,1.2,1.35> }              // Houses are hollow after all
    box { <.75,.125,-.25> <1,.4,1.7> texture {window} }      // Window
    box { <.75,.7,-.25> <1,.9,1.7> texture {window} }       // Window
    box { <1.425,.7,-.25> <1.675,.9,1.7> texture {window} } // Window
    box { <2.25,.125,-.25> <2.5,.4,1.7> texture {window} }     // Window
    box { <2.25,.7,-.25> <2.5,.9,1.7> texture {window} }      // Window
    box { <1.45,-.1,-.25> <1.7,.4,.01> texture {window} }   // Door
  }
  difference {
    box { <1,0,1> <1.2,1.3,1.2> texture {stones}}                     // Smoke pipe, what is it in english ...
    box { <1.05,.5,1.05> <1.15,1.4,1.15> texture {stones} texture {pigment {color rgbt <0,0,0,.5>}}}            // Hollow? Well someone might have a closer look...
  }

  difference {  // Kattokolmio
    box { <0,0,0> <3,-.3,.78745> rotate x*-15 translate y*1 }
    box { -1 , <4,1,2> }
    texture { wall_b }
  }
  difference {  // Kattokolmio
    box { <0,0,0> <3,-.3,-.78745> rotate x*15 translate y*1+z*1.5 }
    box { -1 , <4,1,2> }
    texture { wall_b }
  }

  box { <-.01,.6,-.01> <3.01,.5,1.51> texture { window } }

  box { <-.01,0,-.01> <.125,1,.125> texture { window } }
  box { <1.2,0,-.01> <1.1,1,.125> texture { window } }
  box { <1.9,0,-.01> <2.0,1,.125> texture { window } }
  box { <3.01,0,-.01> <2.875,1,.125> texture { window } }

  box { <-.01,0,.775> <.125,1.2,.725> texture { window } }
  box { <3.01,0,.775> <2.875,1.2,.725> texture { window } }

  box { <-.01,0,1.51> <.125,1,1.375> texture { window } }
  box { <1.2,0,1.51> <1.1,1,1.375> texture { window } }
  box { <1.9,0,1.51> <2.0,1,1.375> texture { window } }
  box { <3.01,0,1.51> <2.875,1,1.375> texture { window } }
  
  // Roof
  box { <-.05,0,-.05> <3.05,.05,.78745> texture { katto } rotate x*-15 translate y*1 }
  box { <-.05,0,.05> <3.05,.05,-.78745> texture { katto } rotate x*15 translate y*1+z*1.5 }
  pigment { color rgb <.32,.17,.12> }  
}

#declare house2 =
union { 
  difference {
    box { <0,0,0> <2,.7,1.5> texture { wall_c } }      // House walls
    box { <.0625,0.0125,.0625> <1.925,1.8,1.425> }     // House is hollow
    box { <.6,.15,-.25> <.85,.43,.25> }                // Window
    box { <-.2,.15,.75> <2.2,.43,1> }                  // Window
    box { <1.3,-.1,-.25> <1.6,.43,.01> }               // Door
    texture {window} 
  }
  difference {
    box { <1.5,0,1> <1.7,1,1.2> texture {stones} }                     // Smoke pipe, what is it in english ...
    box { <1.55,.5,1.05> <1.65,1.3,1.15> texture {stones} texture {pigment {color rgbt <0,0,0,.5>}} }            // Hollow? Well someone might have a closer look...
  }
  difference {  // Kattokolmio
    box { <0,0,0> <2,-.3,.78745> rotate x*-15 translate y*.7 }                // Wall colour
    box { -1 , <4,.7,2> }
    texture { wall_c }
  }
  difference {  // Kattokolmio
    box { <0,0,0> <2,-.3,-.78745> rotate x*15 translate y*.7+z*1.5 }          // Wall colour
    box { -1 , <4,.7,2> }
    texture { wall_c }
  }
  box { <-.05,0,-.05> <2.05,.05,.78745> texture { katto_b translate z*1.5 } rotate x*-15 translate y*.7 }
  box { <-.05,0,.05> <2.05,.05,-.78745> texture { katto_b translate z*1.5} rotate x*15 translate y*.7+z*1.5 }
  scale .92
}

#local wall2b = 
texture { 
  pigment{
    granite 
    colour_map {
      [0 color rgb <.9,.9,.85>*.8]
      [.5 color rgb <.9,.9,.8> ]
      [1 color rgb <.9,.9,.85>*.9]
    }
    scale 1
    turbulence .5
  }
  normal {
    bumps .2 scale .01
  }
}

#declare house2b =
union { 
  difference {
    box { <0,0,0> <2,.75,1.5> texture { wall2b } }    // House walls
    box { <.0625,0.0125,.0625> <1.925,1.8,1.425> }    // House is hollow =)
    box { <.6,.225,-.25> <.85,.4,.25> }                // Window
    box { <-.2,.225,.75> <2.2,.5,1> }                  // Window
    box { <1.4,-.1,-.25> <1.7,.4,.01> }               // Door
    texture {window} 
  }
  difference {
    box { <1,0,1> <1.2,1.1,1.2> texture {stones} }                     // Smoke pipe, what is it in english ...
    box { <1.05,.5,1.05> <1.15,1.4,1.15> texture {stones} texture {pigment {color rgbt <0,0,0,.5>}}}            // Hollow? Well someone might have a closer look...
  }
  difference {  // Kattokolmio
    box { <0,0,0> <2,-.3,.78745> rotate x*-15 translate y*.7 }                // Wall colour
    box { -1 , <4,.75,2> }
    texture { wall2b }
  }
  difference {  // Kattokolmio
      box { <0,0,0> <2,-.3,-.78745> rotate x*15 translate y*.7+z*1.5 }          // Wall colour
    box { -1 , <4,.75,2> }
    texture { wall2b }
  }
  box { <-.05,0,-.05> <2.05,.05,.78745> texture { katto_b } rotate x*-15 translate y*.75 }
  box { <-.05,0,.05> <2.05,.05,-.78745> texture { katto_b } rotate x*15 translate y*.75+z*1.5 }
}


#ifndef (TheCity)
  object { house }
#end

#ifdef (TheCity) #if(!TheCity)
  #declare house = box { <0,0,0> <3,1,1.5> pigment { color rgb <1,.75,.75> } }
  #declare house_b = house 
  #declare house_c = house 
  #declare house2 = box { <0,0,0> <2,.8,1.5> pigment { color rgb <1,.75,.75> } }
  #declare house2b = house2
#end#end
